/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.faction.FactionMenuScreen;
import com.equestricraft.mod.faction.PlayerFactionInformation;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundFactionMenuOpenPacket {
    private final PlayerFactionInformation playerFactionInformation;

    public ClientBoundFactionMenuOpenPacket(PlayerFactionInformation playerFactionInformation) {
        this.playerFactionInformation = playerFactionInformation;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerFactionInformation.factionName());
        buffer.m_130070_(this.playerFactionInformation.factionDescription());
        buffer.writeInt(this.playerFactionInformation.color().getIntValue());
        buffer.m_130070_(this.playerFactionInformation.rankName());
        buffer.m_130070_(this.playerFactionInformation.rankDescription());
    }

    public static ClientBoundFactionMenuOpenPacket decode(FriendlyByteBuf buffer) {
        String factionName = buffer.m_130277_();
        String factionDescription = buffer.m_130277_();
        Argb color = Argb.fromIntValue(buffer.readInt());
        String rankName = buffer.m_130277_();
        String rankDescription = buffer.m_130277_();
        PlayerFactionInformation playerFactionInformation = new PlayerFactionInformation(factionName, factionDescription, color, rankName, rankDescription);
        return new ClientBoundFactionMenuOpenPacket(playerFactionInformation);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> FactionMenuScreen.showScreen(this.playerFactionInformation));
    }
}

