/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.fasttravel.FastTravelGroupInfo;
import com.equestricraft.core.fasttravel.FastTravelPointInfo;
import com.equestricraft.mod.client.gui.FastTravelMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundFastTravelScreenOpenPacket {
    private final FastTravelGroupInfo currentGroup;
    private final FastTravelPointInfo currentPoint;
    private final List<FastTravelPointInfo> points;

    public ClientBoundFastTravelScreenOpenPacket(FastTravelGroupInfo currentGroup, FastTravelPointInfo currentPoint, List<FastTravelPointInfo> points) {
        this.currentGroup = currentGroup;
        this.currentPoint = currentPoint;
        this.points = points;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.currentGroup.groupId());
        buffer.m_130070_(this.currentGroup.groupName());
        buffer.writeDouble(this.currentGroup.groupCost());
        buffer.m_130070_(this.currentGroup.groupCostString());
        buffer.writeInt(this.currentPoint.pointId());
        buffer.m_130070_(this.currentPoint.pointName());
        buffer.writeInt(this.points.size());
        for (FastTravelPointInfo point : this.points) {
            buffer.writeInt(point.pointId());
            buffer.m_130070_(point.pointName());
        }
    }

    public static ClientBoundFastTravelScreenOpenPacket decode(FriendlyByteBuf buffer) {
        int currentGroupId = buffer.readInt();
        String currentGroupName = buffer.m_130277_();
        double currentGroupCost = buffer.readDouble();
        String currentGroupCostString = buffer.m_130277_();
        FastTravelGroupInfo currentGroup = new FastTravelGroupInfo(currentGroupId, currentGroupName, currentGroupCost, currentGroupCostString);
        int currentPointId = buffer.readInt();
        String currentPointName = buffer.m_130277_();
        FastTravelPointInfo currentPoint = new FastTravelPointInfo(currentPointId, currentPointName);
        int pointCount = buffer.readInt();
        ArrayList<FastTravelPointInfo> points = new ArrayList<FastTravelPointInfo>(pointCount);
        for (int i = 0; i < pointCount; ++i) {
            int pointId = buffer.readInt();
            String pointName = buffer.m_130277_();
            FastTravelPointInfo point = new FastTravelPointInfo(pointId, pointName);
            points.add(point);
        }
        return new ClientBoundFastTravelScreenOpenPacket(currentGroup, currentPoint, points);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> FastTravelMenuScreen.showScreen(this.currentGroup, this.currentPoint, this.points));
    }
}

