/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.featureflag.FeatureFlagStateCache;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundFeatureFlagUpdatePacket {
    private final Map<FeatureFlag, Boolean> flags;

    public ClientBoundFeatureFlagUpdatePacket(Map<FeatureFlag, Boolean> flags) {
        this.flags = flags;
    }

    public void encode(FriendlyByteBuf buffer) {
        for (Map.Entry<FeatureFlag, Boolean> entry : this.flags.entrySet()) {
            buffer.m_130068_((Enum)entry.getKey());
            buffer.writeBoolean(entry.getValue().booleanValue());
        }
    }

    public static ClientBoundFeatureFlagUpdatePacket decode(FriendlyByteBuf buffer) {
        EnumMap<FeatureFlag, Boolean> map = new EnumMap<FeatureFlag, Boolean>(FeatureFlag.class);
        for (int i = 0; i < FeatureFlag.values().length; ++i) {
            FeatureFlag flag = (FeatureFlag)buffer.m_130066_(FeatureFlag.class);
            boolean state = buffer.readBoolean();
            map.put(flag, state);
        }
        return new ClientBoundFeatureFlagUpdatePacket(map);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            FeatureFlagStateCache instance = FeatureFlagStateCache.getInstance();
            instance.setStates(this.flags);
        });
    }
}

