/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.information.HorseBreedCertificateInformation;
import com.equestricraft.core.horse.information.HorseIndividualBreedViewItem;
import com.equestricraft.mod.client.gui.horse.breed.BreedCertificateScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseBreedCertificateMenuOpenPacket {
    private final HorseBreedCertificateInformation info;

    public ClientBoundHorseBreedCertificateMenuOpenPacket(HorseBreedCertificateInformation info2) {
        this.info = info2;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.info.horseName());
        buffer.m_130070_(this.info.display());
        buffer.writeInt(this.info.breeds().size());
        for (HorseIndividualBreedViewItem breed : this.info.breeds()) {
            buffer.writeInt(breed.id());
            buffer.m_130070_(breed.name());
            buffer.m_130070_(breed.percentage());
            buffer.m_130070_(breed.description());
        }
    }

    public static ClientBoundHorseBreedCertificateMenuOpenPacket decode(FriendlyByteBuf buffer) {
        String horseName = buffer.m_130277_();
        String breedDisplay = buffer.m_130277_();
        int breedsCount = buffer.readInt();
        ArrayList<HorseIndividualBreedViewItem> breeds = new ArrayList<HorseIndividualBreedViewItem>(breedsCount);
        for (int i = 0; i < breedsCount; ++i) {
            int breedId = buffer.readInt();
            String breedName = buffer.m_130277_();
            String breedPercentage = buffer.m_130277_();
            String breedDescription = buffer.m_130277_();
            HorseIndividualBreedViewItem breed = new HorseIndividualBreedViewItem(breedId, breedName, breedPercentage, breedDescription);
            breeds.add(breed);
        }
        HorseBreedCertificateInformation breedData = new HorseBreedCertificateInformation(horseName, breedDisplay, breeds);
        return new ClientBoundHorseBreedCertificateMenuOpenPacket(breedData);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> BreedCertificateScreen.showHorseBreedDataMenu(this.info));
    }
}

