/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.information.HorseCertificatesInfo;
import com.equestricraft.mod.client.gui.horse.HorseCertificatesScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseCertificateMenuOpenPacket {
    private final HorseSimple horse;
    private final HorseCertificatesInfo info;

    public ClientBoundHorseCertificateMenuOpenPacket(HorseSimple horse, HorseCertificatesInfo info2) {
        this.horse = horse;
        this.info = info2;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeBoolean(this.info.hasBreedCertificate());
        buffer.writeBoolean(this.info.hasRegistrationCertificate());
    }

    public static ClientBoundHorseCertificateMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        boolean hasBreedCertificate = buffer.readBoolean();
        boolean hasRegistrationCertificate = buffer.readBoolean();
        HorseCertificatesInfo info2 = new HorseCertificatesInfo(hasBreedCertificate, hasRegistrationCertificate);
        return new ClientBoundHorseCertificateMenuOpenPacket(horse, info2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseCertificatesScreen.showScreen(this.horse, this.info));
    }
}

