/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.conformation.check.ConformationCheckRating;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.mod.client.gui.horse.conformation.HorseConformationCheckScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.horse.conformation.HorseConformationCheckInfo;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseConformationCheckScreenOpenPacket {
    private final HorseSimple horse;
    private final List<HorseConformationCheckInfo> infoList;

    public ClientBoundHorseConformationCheckScreenOpenPacket(HorseSimple horse, List<HorseConformationCheckInfo> infoList) {
        this.horse = horse;
        this.infoList = infoList;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.infoList.size());
        for (HorseConformationCheckInfo info2 : this.infoList) {
            buffer.m_130070_(info2.name());
            buffer.m_130070_(info2.description());
            buffer.m_130068_((Enum)info2.rating());
            buffer.writeInt(info2.speedEffect());
            buffer.writeInt(info2.jumpEffect());
            buffer.writeInt(info2.staminaEffect());
        }
    }

    public static ClientBoundHorseConformationCheckScreenOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int amount = buffer.readInt();
        ArrayList<HorseConformationCheckInfo> infoList = new ArrayList<HorseConformationCheckInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            ConformationCheckRating rating = (ConformationCheckRating)buffer.m_130066_(ConformationCheckRating.class);
            int speedEffect = buffer.readInt();
            int jumpEffect = buffer.readInt();
            int staminaEffect = buffer.readInt();
            HorseConformationCheckInfo info2 = new HorseConformationCheckInfo(name, description, rating, speedEffect, jumpEffect, staminaEffect);
            infoList.add(info2);
        }
        return new ClientBoundHorseConformationCheckScreenOpenPacket(horse, infoList);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseConformationCheckScreen.showScreen(this.horse, this.infoList));
    }
}

