/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.mod.client.gui.horse.conformation.HorseConformationMeasurementScreen;
import com.equestricraft.mod.horse.conformation.HorseConformationMeasurementInfo;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseConformationMeasurementsScreenOpenPacket {
    private final int horseId;
    private final List<HorseConformationMeasurementInfo> infoList;

    public ClientBoundHorseConformationMeasurementsScreenOpenPacket(int horseId, List<HorseConformationMeasurementInfo> infoList) {
        this.horseId = horseId;
        this.infoList = infoList;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.infoList.size());
        for (HorseConformationMeasurementInfo info2 : this.infoList) {
            buffer.writeInt(info2.id());
            buffer.m_130068_((Enum)info2.type());
            buffer.m_130070_(info2.name());
            buffer.m_130070_(info2.displayValue());
        }
    }

    public static ClientBoundHorseConformationMeasurementsScreenOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int amount = buffer.readInt();
        ArrayList<HorseConformationMeasurementInfo> infoList = new ArrayList<HorseConformationMeasurementInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            ConformationMeasurementType type = (ConformationMeasurementType)buffer.m_130066_(ConformationMeasurementType.class);
            String name = buffer.m_130277_();
            String displayValue = buffer.m_130277_();
            HorseConformationMeasurementInfo info2 = new HorseConformationMeasurementInfo(id, type, name, displayValue);
            infoList.add(info2);
        }
        return new ClientBoundHorseConformationMeasurementsScreenOpenPacket(horseId, infoList);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseConformationMeasurementScreen.showScreen(this.horseId, this.infoList));
    }
}

