/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.breed.BreedInfo;
import com.equestricraft.mod.client.gui.horse.create.HorseCreateMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseCreateBreedUpdatePacket {
    private final List<BreedInfo> breeds;

    public ClientBoundHorseCreateBreedUpdatePacket(List<BreedInfo> breeds) {
        this.breeds = breeds;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.breeds.size());
        for (BreedInfo breed : this.breeds) {
            buffer.writeInt(breed.breedId());
            buffer.m_130070_(breed.breedName());
            buffer.m_130070_(breed.description());
        }
    }

    public static ClientBoundHorseCreateBreedUpdatePacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<BreedInfo> breeds = new ArrayList<BreedInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            breeds.add(new BreedInfo(id, name, description));
        }
        return new ClientBoundHorseCreateBreedUpdatePacket(breeds);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseCreateMenuScreen.setBreeds(this.breeds));
    }
}

