/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.core.horse.create.ValidHorseCreateSelections;
import com.equestricraft.mod.client.gui.horse.create.HorseCreateMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseCreateValidSelectionsUpdatePacket {
    private final ValidHorseCreateSelections validHorseCreateSelections;

    public ClientBoundHorseCreateValidSelectionsUpdatePacket(ValidHorseCreateSelections validHorseCreateSelections) {
        this.validHorseCreateSelections = validHorseCreateSelections;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.validHorseCreateSelections.minimumHeight());
        buffer.writeDouble(this.validHorseCreateSelections.maximumHeight());
        this.encodeList(buffer, this.validHorseCreateSelections.colors());
        this.encodeList(buffer, this.validHorseCreateSelections.requiredMarkings());
        this.encodeList(buffer, this.validHorseCreateSelections.optionalMarkings());
        this.encodeList(buffer, this.validHorseCreateSelections.requiredMarkingGroups());
        this.encodeList(buffer, this.validHorseCreateSelections.optionalMarkingGroups());
        buffer.writeDouble(this.validHorseCreateSelections.stallionMinimumWeight());
        buffer.writeDouble(this.validHorseCreateSelections.stallionMaximumWeight());
        buffer.writeDouble(this.validHorseCreateSelections.mareMinimumWeight());
        buffer.writeDouble(this.validHorseCreateSelections.mareMaximumWeight());
    }

    private <T extends Enum<T>> void encodeList(FriendlyByteBuf buffer, List<T> list) {
        buffer.writeInt(list.size());
        for (Enum item : list) {
            buffer.m_130068_(item);
        }
    }

    public static ClientBoundHorseCreateValidSelectionsUpdatePacket decode(FriendlyByteBuf buffer) {
        double minimumHeight = buffer.readDouble();
        double maximumHeight = buffer.readDouble();
        List<HorseCoatColor> colors = ClientBoundHorseCreateValidSelectionsUpdatePacket.decodeList(buffer, HorseCoatColor.class);
        List<HorseCoatMarking> requiredMarkings = ClientBoundHorseCreateValidSelectionsUpdatePacket.decodeList(buffer, HorseCoatMarking.class);
        List<HorseCoatMarking> optionalMarkings = ClientBoundHorseCreateValidSelectionsUpdatePacket.decodeList(buffer, HorseCoatMarking.class);
        List<HorseCoatMarking.MarkingGroup> requiredMarkingGroups = ClientBoundHorseCreateValidSelectionsUpdatePacket.decodeList(buffer, HorseCoatMarking.MarkingGroup.class);
        List<HorseCoatMarking.MarkingGroup> optionalMarkingGroups = ClientBoundHorseCreateValidSelectionsUpdatePacket.decodeList(buffer, HorseCoatMarking.MarkingGroup.class);
        double stallionMinimumWeight = buffer.readDouble();
        double stallionMaximumWeight = buffer.readDouble();
        double mareMinimumWeight = buffer.readDouble();
        double mareMaximumWeight = buffer.readDouble();
        ValidHorseCreateSelections validSelections = new ValidHorseCreateSelections(minimumHeight, maximumHeight, colors, requiredMarkings, optionalMarkings, requiredMarkingGroups, optionalMarkingGroups, stallionMinimumWeight, stallionMaximumWeight, mareMinimumWeight, mareMaximumWeight);
        return new ClientBoundHorseCreateValidSelectionsUpdatePacket(validSelections);
    }

    private static <T extends Enum<T>> List<T> decodeList(FriendlyByteBuf buffer, Class<T> clazz) {
        int size = buffer.readInt();
        ArrayList<Enum> list = new ArrayList<Enum>(size);
        for (int i = 0; i < size; ++i) {
            Enum item = buffer.m_130066_(clazz);
            list.add(item);
        }
        return list;
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseCreateMenuScreen.setValidSelections(this.validHorseCreateSelections));
    }
}

