/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.horse.dead.HorseDeathCertificateScreen;
import com.equestricraft.mod.horse.dead.HorseDeathCertificate;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseDeathCertificateMenuOpenPacket {
    private final HorseDeathCertificate certificate;

    public ClientBoundHorseDeathCertificateMenuOpenPacket(HorseDeathCertificate certificate) {
        this.certificate = certificate;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.certificate.horseId());
        buffer.m_130070_(this.certificate.horseName());
        if (this.certificate.horseShowName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.certificate.horseShowName());
        } else {
            buffer.writeBoolean(false);
        }
        PlayerSerializer.serializePlayerSimple(this.certificate.owner(), buffer);
        buffer.m_130070_(this.certificate.deathTime());
        buffer.m_130070_(this.certificate.causeOfDeath());
    }

    public static ClientBoundHorseDeathCertificateMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        String horseName = buffer.m_130277_();
        String showName = buffer.readBoolean() ? buffer.m_130277_() : null;
        PlayerSimple owner = PlayerSerializer.deserializePlayerSimple(buffer);
        String deathTime = buffer.m_130277_();
        String causeOfDeath = buffer.m_130277_();
        HorseDeathCertificate info2 = new HorseDeathCertificate(horseId, horseName, showName, owner, deathTime, causeOfDeath);
        return new ClientBoundHorseDeathCertificateMenuOpenPacket(info2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseDeathCertificateScreen.showScreen(this.certificate));
    }
}

