/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.bit.BitInformation;
import com.equestricraft.core.horse.information.HorseDetailsInformation;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.horse.shoe.ShoeInformation;
import com.equestricraft.core.horse.weight.HorseWeightInfo;
import com.equestricraft.core.horse.weight.WeightStatus;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.horse.HorseDetailsScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.Date;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseDetailsViewMenuOpenPacket {
    private final int horseId;
    private final HorseDetailsInformation details;

    public ClientBoundHorseDetailsViewMenuOpenPacket(int horseId, HorseDetailsInformation details) {
        this.horseId = horseId;
        this.details = details;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.m_130070_(this.details.name());
        if (this.details.owner() != null) {
            buffer.writeBoolean(true);
            PlayerSerializer.serializePlayerSimple(this.details.owner(), buffer);
        } else {
            buffer.writeBoolean(false);
        }
        if (this.details.showName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.details.showName());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130070_(this.details.gender());
        buffer.m_130070_(this.details.ageDisplay());
        buffer.writeBoolean(this.details.hasParents());
        buffer.writeBoolean(this.details.immortal());
        if (this.details.weight() != null) {
            buffer.writeBoolean(true);
            buffer.writeDouble(this.details.weight().currentWeight());
            buffer.writeDouble(this.details.weight().targetWeight());
            buffer.m_130068_((Enum)this.details.weight().status());
            buffer.m_130075_(this.details.weight().lastTime());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130070_(this.details.trustLevel());
        buffer.m_130070_(this.details.breed());
        buffer.writeBoolean(this.details.hasBreedCertificate());
        buffer.m_130070_(this.details.currentValue());
        buffer.m_130068_((Enum)this.details.playerAccessLevel());
        buffer.writeBoolean(this.details.microchipped());
        if (this.details.shoeInformation() != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.details.shoeInformation().id());
            buffer.m_130070_(this.details.shoeInformation().name());
            buffer.writeDouble(this.details.shoeInformation().conditionPercentage());
            buffer.writeBoolean(this.details.shoeInformation().shoeMissing());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.details.bitInformation() != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.details.bitInformation().id());
            buffer.m_130070_(this.details.bitInformation().name());
            buffer.writeDouble(this.details.bitInformation().conditionPercentage());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeDouble(this.details.height());
        buffer.m_130070_(this.details.coatDescription());
    }

    public static ClientBoundHorseDetailsViewMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        String name = buffer.m_130277_();
        PlayerSimple owner = buffer.readBoolean() ? PlayerSerializer.deserializePlayerSimple(buffer) : null;
        String showName = buffer.readBoolean() ? buffer.m_130277_() : null;
        String gender = buffer.m_130277_();
        String ageDisplay = buffer.m_130277_();
        boolean hasParents = buffer.readBoolean();
        boolean immortal = buffer.readBoolean();
        HorseWeightInfo weightInfo = null;
        if (buffer.readBoolean()) {
            double currentWeight = buffer.readDouble();
            double targetWeight = buffer.readDouble();
            WeightStatus weightStatus = (WeightStatus)buffer.m_130066_(WeightStatus.class);
            Date lastTime = buffer.m_130282_();
            weightInfo = new HorseWeightInfo(currentWeight, targetWeight, weightStatus, lastTime);
        }
        String trustLevel = buffer.m_130277_();
        String breed = buffer.m_130277_();
        boolean hasBreedCertificate = buffer.readBoolean();
        String currentValue = buffer.m_130277_();
        HorsePermissionLevel playerAccessLevel = (HorsePermissionLevel)buffer.m_130066_(HorsePermissionLevel.class);
        boolean microchipped = buffer.readBoolean();
        ShoeInformation shoeInformation = null;
        if (buffer.readBoolean()) {
            int shoeId = buffer.readInt();
            String shoeName = buffer.m_130277_();
            double conditionPercentage = buffer.readDouble();
            boolean shoeMissing = buffer.readBoolean();
            shoeInformation = new ShoeInformation(shoeId, shoeName, conditionPercentage, shoeMissing);
        }
        BitInformation bitInformation = null;
        if (buffer.readBoolean()) {
            int bitId = buffer.readInt();
            String bitName = buffer.m_130277_();
            double conditionPercentage = buffer.readDouble();
            bitInformation = new BitInformation(bitId, bitName, conditionPercentage);
        }
        double height = buffer.readDouble();
        String coatDescription = buffer.m_130277_();
        HorseDetailsInformation details = new HorseDetailsInformation(name, owner, showName, gender, ageDisplay, hasParents, immortal, weightInfo, trustLevel, breed, hasBreedCertificate, currentValue, playerAccessLevel, microchipped, shoeInformation, bitInformation, height, coatDescription);
        return new ClientBoundHorseDetailsViewMenuOpenPacket(horseId, details);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseDetailsScreen.showMenu(this.horseId, this.details));
    }
}

