/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.mod.client.gui.horse.discipline.HorseDisciplineScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.horse.discipline.HorseDisciplineInfo;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseDisciplineMenuOpenPacket {
    private final HorseSimple horse;
    private final Date lastCertification;
    private final List<HorseDisciplineInfo> disciplines;

    public ClientBoundHorseDisciplineMenuOpenPacket(HorseSimple horse, Date lastCertification, List<HorseDisciplineInfo> disciplines) {
        this.horse = horse;
        this.lastCertification = lastCertification;
        this.disciplines = disciplines;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        if (this.lastCertification != null) {
            buffer.writeBoolean(true);
            buffer.m_130075_(this.lastCertification);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.disciplines.size());
        for (HorseDisciplineInfo discipline : this.disciplines) {
            buffer.writeInt(discipline.id());
            buffer.m_130070_(discipline.name());
            buffer.m_130070_(discipline.description());
        }
    }

    public static ClientBoundHorseDisciplineMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        Date lastCertification = buffer.readBoolean() ? buffer.m_130282_() : null;
        int amount = buffer.readInt();
        ArrayList<HorseDisciplineInfo> disciplineInfos = new ArrayList<HorseDisciplineInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            HorseDisciplineInfo info2 = new HorseDisciplineInfo(id, name, description);
            disciplineInfos.add(info2);
        }
        return new ClientBoundHorseDisciplineMenuOpenPacket(horse, lastCertification, disciplineInfos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseDisciplineScreen.showScreen(this.horse, this.lastCertification, this.disciplines));
    }
}

