/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.gui.horse.illness.HorseIllnessDetailsScreen;
import com.equestricraft.mod.horse.illness.HorseIllnessDetailsInfo;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseIllnessDetailsMenuOpenPacket {
    private final HorseIllnessDetailsInfo info;

    public ClientBoundHorseIllnessDetailsMenuOpenPacket(HorseIllnessDetailsInfo info2) {
        this.info = info2;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.info.illnessId());
        buffer.m_130070_(this.info.illnessName());
        buffer.m_130070_(this.info.illnessDescription());
        buffer.m_130070_(this.info.durationDisplay());
        if (this.info.notes() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.info.notes());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.info.medicines().size());
        for (HorseIllnessDetailsInfo.MedicineInfo medicine : this.info.medicines()) {
            buffer.writeInt(medicine.medicineId());
            buffer.m_130070_(medicine.medicineName());
        }
    }

    public static ClientBoundHorseIllnessDetailsMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int illnessId = buffer.readInt();
        String illnessName = buffer.m_130277_();
        String illnessDescription = buffer.m_130277_();
        String durationDisplay = buffer.m_130277_();
        String notes = buffer.readBoolean() ? buffer.m_130277_() : null;
        int medicineCount = buffer.readInt();
        ArrayList<HorseIllnessDetailsInfo.MedicineInfo> medicines = new ArrayList<HorseIllnessDetailsInfo.MedicineInfo>(medicineCount);
        for (int i = 0; i < medicineCount; ++i) {
            int medicineId = buffer.readInt();
            String medicineName = buffer.m_130277_();
            HorseIllnessDetailsInfo.MedicineInfo medicine = new HorseIllnessDetailsInfo.MedicineInfo(medicineId, medicineName);
            medicines.add(medicine);
        }
        HorseIllnessDetailsInfo info2 = new HorseIllnessDetailsInfo(illnessId, illnessName, illnessDescription, durationDisplay, notes, medicines);
        return new ClientBoundHorseIllnessDetailsMenuOpenPacket(info2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseIllnessDetailsScreen.showScreen(this.info));
    }
}

