/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.information.HorseIllnessViewInformation;
import com.equestricraft.mod.client.gui.horse.illness.HorseIllnessScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseIllnessViewMenuOpenPacket {
    private final HorseSimple horse;
    private final List<HorseIllnessViewInformation> illnesses;
    private final boolean diagnosisMode;

    public ClientBoundHorseIllnessViewMenuOpenPacket(HorseSimple horse, List<HorseIllnessViewInformation> illnesses, boolean diagnosisMode) {
        this.horse = horse;
        this.illnesses = illnesses;
        this.diagnosisMode = diagnosisMode;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.illnesses.size());
        for (HorseIllnessViewInformation illness : this.illnesses) {
            buffer.writeInt(illness.illnessId());
            buffer.m_130070_(illness.illnessName());
            buffer.m_130070_(illness.illnessDescription());
            if (illness.messageForTrainedPlayers() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(illness.messageForTrainedPlayers());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130070_(illness.durationDisplay());
            if (illness.notes() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(illness.notes());
            } else {
                buffer.writeBoolean(false);
            }
            if (illness.diagnosisCostDisplay() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(illness.diagnosisCostDisplay());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(illness.diagnosed());
            buffer.writeDouble(illness.curePercentage());
        }
        buffer.writeBoolean(this.diagnosisMode);
    }

    public static ClientBoundHorseIllnessViewMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int illnessCount = buffer.readInt();
        ArrayList<HorseIllnessViewInformation> illnesses = new ArrayList<HorseIllnessViewInformation>(illnessCount);
        for (int i = 0; i < illnessCount; ++i) {
            int illnessId = buffer.readInt();
            String illnessName = buffer.m_130277_();
            String illnessDescription = buffer.m_130277_();
            String messageForTrainedPlayers = buffer.readBoolean() ? buffer.m_130277_() : null;
            String durationDisplay = buffer.m_130277_();
            String notes = buffer.readBoolean() ? buffer.m_130277_() : null;
            String diagnosisCostDisplay = buffer.readBoolean() ? buffer.m_130277_() : null;
            boolean diagnosed = buffer.readBoolean();
            double cureProgress = buffer.readDouble();
            HorseIllnessViewInformation illness = new HorseIllnessViewInformation(illnessId, illnessName, illnessDescription, messageForTrainedPlayers, durationDisplay, notes, diagnosisCostDisplay, diagnosed, cureProgress);
            illnesses.add(illness);
        }
        boolean diagnosisMode = buffer.readBoolean();
        return new ClientBoundHorseIllnessViewMenuOpenPacket(horse, illnesses, diagnosisMode);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseIllnessScreen.showHorseIllnessesMenu(this.horse, this.illnesses, this.diagnosisMode));
    }
}

