/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.instruction.HorseInstructionInfo;
import com.equestricraft.core.horse.instruction.HorseInstructionState;
import com.equestricraft.core.horse.instruction.HorseInstructionType;
import com.equestricraft.mod.client.gui.horse.HorseInstructionMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseInstructionGiveMenuOpenPacket {
    private final UUID horseEntityUuid;
    private final List<HorseInstructionInfo> instructions;

    public ClientBoundHorseInstructionGiveMenuOpenPacket(UUID horseEntityUuid, List<HorseInstructionInfo> instructions) {
        this.horseEntityUuid = horseEntityUuid;
        this.instructions = instructions;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.horseEntityUuid);
        buffer.writeInt(this.instructions.size());
        for (HorseInstructionInfo instruction : this.instructions) {
            buffer.m_130070_(instruction.label());
            buffer.m_130068_((Enum)instruction.type());
            buffer.m_130068_((Enum)instruction.state());
        }
    }

    public static ClientBoundHorseInstructionGiveMenuOpenPacket decode(FriendlyByteBuf buffer) {
        UUID horseEntityUuid = buffer.m_130259_();
        int amount = buffer.readInt();
        ArrayList<HorseInstructionInfo> instructions = new ArrayList<HorseInstructionInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            String label = buffer.m_130277_();
            HorseInstructionType type = (HorseInstructionType)buffer.m_130066_(HorseInstructionType.class);
            HorseInstructionState state = (HorseInstructionState)buffer.m_130066_(HorseInstructionState.class);
            HorseInstructionInfo instruction = new HorseInstructionInfo(label, type, state);
            instructions.add(instruction);
        }
        return new ClientBoundHorseInstructionGiveMenuOpenPacket(horseEntityUuid, instructions);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseInstructionMenuScreen.showScreen(this.horseEntityUuid, this.instructions));
    }
}

