/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.list.HorseListItem;
import com.equestricraft.core.horse.list.HorseListPage;
import com.equestricraft.core.horse.list.HorseListSortOrder;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.horse.list.HorseListScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseListMenuOpenPacket {
    private final HorseListPage page;

    public ClientBoundHorseListMenuOpenPacket(HorseListPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (HorseListItem item : this.page.getItems()) {
            buffer.writeInt(item.id());
            buffer.m_130070_(item.name());
            if (item.showName() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(item.showName());
            } else {
                buffer.writeBoolean(false);
            }
            if (item.owner() != null) {
                buffer.writeBoolean(true);
                PlayerSerializer.serializePlayerSimple(item.owner(), buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130070_(item.gender());
            buffer.m_130070_(item.age());
            buffer.writeBoolean(item.immortal());
            buffer.m_130068_((Enum)item.horseHealth());
        }
        buffer.m_130068_((Enum)this.page.getSortOrder());
        buffer.m_130068_((Enum)this.page.getSortDirection());
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130070_((String)this.page.getFilterObject());
    }

    public static ClientBoundHorseListMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int itemCount = buffer.readInt();
        ArrayList<HorseListItem> items = new ArrayList<HorseListItem>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String showName = buffer.readBoolean() ? buffer.m_130277_() : null;
            PlayerSimple owner = buffer.readBoolean() ? PlayerSerializer.deserializePlayerSimple(buffer) : null;
            String gender = buffer.m_130277_();
            String age = buffer.m_130277_();
            boolean immortal = buffer.readBoolean();
            HorseHealth horseHealth = (HorseHealth)buffer.m_130066_(HorseHealth.class);
            HorseListItem item = new HorseListItem(id, name, showName, owner, gender, age, immortal, horseHealth);
            items.add(item);
        }
        HorseListSortOrder sortOrder = (HorseListSortOrder)buffer.m_130066_(HorseListSortOrder.class);
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        int pageNumber = buffer.readInt();
        int totalPage = buffer.readInt();
        String textSearch = buffer.m_130277_();
        HorseListPage page = new HorseListPage(items, sortOrder, sortDirection, pageNumber, totalPage, textSearch);
        return new ClientBoundHorseListMenuOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseListScreen.showScreen(this.page));
    }
}

