/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.medicine.HorseMedicineInformation;
import com.equestricraft.mod.client.gui.horse.medicine.HorseMedicineScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseMedicinesViewMenuOpenPacket {
    private final HorseSimple horse;
    private final List<HorseMedicineInformation> medicines;

    public ClientBoundHorseMedicinesViewMenuOpenPacket(HorseSimple horse, List<HorseMedicineInformation> medicines) {
        this.horse = horse;
        this.medicines = medicines;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.medicines.size());
        for (HorseMedicineInformation medicine : this.medicines) {
            buffer.writeInt(medicine.medicineId());
            buffer.m_130070_(medicine.medicineName());
            buffer.m_130070_(medicine.medicineDescription());
            buffer.writeInt(medicine.amount());
            buffer.m_130070_(medicine.unitName());
            buffer.writeBoolean(medicine.boosterNeeded());
            buffer.writeBoolean(medicine.dailyOverdose());
            buffer.writeBoolean(medicine.maximumOverdose());
        }
    }

    public static ClientBoundHorseMedicinesViewMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int medicineCount = buffer.readInt();
        ArrayList<HorseMedicineInformation> medicines = new ArrayList<HorseMedicineInformation>(medicineCount);
        for (int i = 0; i < medicineCount; ++i) {
            int medicineId = buffer.readInt();
            String medicineName = buffer.m_130277_();
            String medicineDescription = buffer.m_130277_();
            int amount = buffer.readInt();
            String unitName = buffer.m_130277_();
            boolean boosterNeeded = buffer.readBoolean();
            boolean dailyOverdose = buffer.readBoolean();
            boolean maximumOverdose = buffer.readBoolean();
            HorseMedicineInformation medicine = new HorseMedicineInformation(medicineId, medicineName, medicineDescription, amount, unitName, boosterNeeded, dailyOverdose, maximumOverdose);
            medicines.add(medicine);
        }
        return new ClientBoundHorseMedicinesViewMenuOpenPacket(horse, medicines);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseMedicineScreen.showHorseMedicinesMenu(this.horse, this.medicines));
    }
}

