/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.information.HorseIndividualParentViewItem;
import com.equestricraft.core.horse.information.HorseParentalViewInformation;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.horse.HorseParentScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseParentViewMenuOpenPacket {
    private final HorseSimple horse;
    private final HorseParentalViewInformation parentalInfo;

    public ClientBoundHorseParentViewMenuOpenPacket(HorseSimple horse, HorseParentalViewInformation parentalInfo) {
        this.horse = horse;
        this.parentalInfo = parentalInfo;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        PlayerSerializer.serializePlayerSimple(this.parentalInfo.mother().owner(), buffer);
        buffer.m_130070_(this.parentalInfo.mother().name());
        if (this.parentalInfo.mother().showName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.parentalInfo.mother().showName());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(this.parentalInfo.mother().alive().booleanValue());
        PlayerSerializer.serializePlayerSimple(this.parentalInfo.father().owner(), buffer);
        buffer.m_130070_(this.parentalInfo.father().name());
        if (this.parentalInfo.father().showName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.parentalInfo.father().showName());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(this.parentalInfo.father().alive().booleanValue());
    }

    public static ClientBoundHorseParentViewMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        PlayerSimple motherOwner = PlayerSerializer.deserializePlayerSimple(buffer);
        String motherName = buffer.m_130277_();
        String motherShowName = null;
        boolean motherHasShowName = buffer.readBoolean();
        if (motherHasShowName) {
            motherShowName = buffer.m_130277_();
        }
        boolean motherAlive = buffer.readBoolean();
        HorseIndividualParentViewItem mother = new HorseIndividualParentViewItem(motherOwner, motherName, motherShowName, motherAlive);
        PlayerSimple fatherOwner = PlayerSerializer.deserializePlayerSimple(buffer);
        String fatherName = buffer.m_130277_();
        String fatherShowName = null;
        boolean fatherHasShowName = buffer.readBoolean();
        if (fatherHasShowName) {
            fatherShowName = buffer.m_130277_();
        }
        boolean fatherAlive = buffer.readBoolean();
        HorseIndividualParentViewItem father = new HorseIndividualParentViewItem(fatherOwner, fatherName, fatherShowName, fatherAlive);
        HorseParentalViewInformation parentalInfo = new HorseParentalViewInformation(mother, father);
        return new ClientBoundHorseParentViewMenuOpenPacket(horse, parentalInfo);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseParentScreen.showHorseParentsMenu(this.horse, this.parentalInfo));
    }
}

