/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.access.HorsePlayerAccessPage;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.horse.access.HorsePlayerAccessScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorsePlayerAccessScreenOpenPacket {
    private final HorseSimple horse;
    private final HorsePlayerAccessPage page;

    public ClientBoundHorsePlayerAccessScreenOpenPacket(HorseSimple horse, HorsePlayerAccessPage page) {
        this.horse = horse;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.page.getItems().size());
        for (PlayerSimple entry : this.page.getItems()) {
            PlayerSerializer.serializePlayerSimple(entry, buffer);
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundHorsePlayerAccessScreenOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int size = buffer.readInt();
        ArrayList<PlayerSimple> entries = new ArrayList<PlayerSimple>(size);
        for (int i = 0; i < size; ++i) {
            PlayerSimple playerSimple = PlayerSerializer.deserializePlayerSimple(buffer);
            entries.add(playerSimple);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        HorsePlayerAccessPage page = new HorsePlayerAccessPage((List<PlayerSimple>)entries, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundHorsePlayerAccessScreenOpenPacket(horse, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorsePlayerAccessScreen.showScreen(this.horse, this.page));
    }
}

