/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.mod.client.gui.horse.progression.HorseProgressionScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.horse.progression.HorseProgressionMilestoneInfo;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseProgressionMenuOpenPacket {
    private final HorseSimple horse;
    private final List<HorseProgressionMilestoneInfo> milestones;

    public ClientBoundHorseProgressionMenuOpenPacket(HorseSimple horse, List<HorseProgressionMilestoneInfo> milestones) {
        this.horse = horse;
        this.milestones = milestones;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.milestones.size());
        for (HorseProgressionMilestoneInfo milestone : this.milestones) {
            buffer.m_130070_(milestone.name());
            buffer.m_130070_(milestone.group());
            buffer.writeInt(milestone.xpRequired());
            buffer.writeBoolean(milestone.unlocked());
        }
    }

    public static ClientBoundHorseProgressionMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int amount = buffer.readInt();
        ArrayList<HorseProgressionMilestoneInfo> milestoneInfos = new ArrayList<HorseProgressionMilestoneInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            String name = buffer.m_130277_();
            String group = buffer.m_130277_();
            int xpRequired = buffer.readInt();
            boolean unlocked = buffer.readBoolean();
            HorseProgressionMilestoneInfo milestone = new HorseProgressionMilestoneInfo(name, group, xpRequired, unlocked);
            milestoneInfos.add(milestone);
        }
        return new ClientBoundHorseProgressionMenuOpenPacket(horse, milestoneInfos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseProgressionScreen.showScreen(this.horse, this.milestones));
    }
}

