/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.HorseGender;
import com.equestricraft.core.horse.registration.HorseRegistrationCertificateDetails;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.registrationorganization.OrganizationInfo;
import com.equestricraft.mod.client.gui.horse.HorseRegistrationCertificateScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.Date;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseRegistrationCertificateOpenPacket {
    private final HorseRegistrationCertificateDetails details;

    public ClientBoundHorseRegistrationCertificateOpenPacket(HorseRegistrationCertificateDetails details) {
        this.details = details;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.details.organization().id());
        buffer.m_130070_(this.details.organization().name());
        buffer.m_130070_(this.details.organization().description());
        buffer.writeInt(this.details.horseId());
        buffer.m_130070_(this.details.registrationNumber());
        buffer.m_130070_(this.details.showName());
        PlayerSerializer.serializePlayerSimple(this.details.currentOwner(), buffer);
        buffer.m_130068_((Enum)this.details.gender());
        buffer.m_130075_(this.details.dateOfBirth());
        buffer.m_130075_(this.details.registrationDate());
        PlayerSerializer.serializePlayerSimple(this.details.registeredByPlayer(), buffer);
        buffer.m_130070_(this.details.breed());
    }

    public static ClientBoundHorseRegistrationCertificateOpenPacket decode(FriendlyByteBuf buffer) {
        int organizationId = buffer.readInt();
        String organizationName = buffer.m_130277_();
        String organizationDescription = buffer.m_130277_();
        OrganizationInfo organization = new OrganizationInfo(organizationId, organizationName, organizationDescription);
        int horseId = buffer.readInt();
        String registrationNumber = buffer.m_130277_();
        String showName = buffer.m_130277_();
        PlayerSimple currentOwner = PlayerSerializer.deserializePlayerSimple(buffer);
        HorseGender gender = (HorseGender)buffer.m_130066_(HorseGender.class);
        Date dateOfBirth = buffer.m_130282_();
        Date registrationDate = buffer.m_130282_();
        PlayerSimple registeredByPlayer = PlayerSerializer.deserializePlayerSimple(buffer);
        String breed = buffer.m_130277_();
        HorseRegistrationCertificateDetails details = new HorseRegistrationCertificateDetails(organization, horseId, registrationNumber, currentOwner, showName, gender, dateOfBirth, registrationDate, registeredByPlayer, breed);
        return new ClientBoundHorseRegistrationCertificateOpenPacket(details);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseRegistrationCertificateScreen.showScreen(this.details));
    }
}

