/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganizationSimple;
import com.equestricraft.mod.client.gui.horseregistration.HorseRegistrationOrganizationMenu;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import com.equestricraft.mod.registration.HorseRegistrationOrganizationInfo;
import com.equestricraft.mod.registration.HorseRegistrationOrganizationSerializer;
import java.util.Date;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseRegistrationOrganizationMenuOpenPacket {
    private final HorseRegistrationOrganizationInfo info;

    public ClientBoundHorseRegistrationOrganizationMenuOpenPacket(HorseRegistrationOrganizationInfo info2) {
        this.info = info2;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseRegistrationOrganizationSerializer.serialize(this.info.organization(), buffer);
        buffer.writeInt(this.info.horseId());
        if (this.info.registrationNumber() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.info.registrationNumber());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.info.showName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.info.showName());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.info.registeredByPlayer() != null) {
            buffer.writeBoolean(true);
            PlayerSerializer.serializePlayerSimple(this.info.registeredByPlayer(), buffer);
        } else {
            buffer.writeBoolean(false);
        }
        if (this.info.registrationDate() != null) {
            buffer.writeBoolean(true);
            buffer.m_130075_(this.info.registrationDate());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundHorseRegistrationOrganizationMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseRegistrationOrganizationSimple organization = HorseRegistrationOrganizationSerializer.deserialize(buffer);
        int horseId = buffer.readInt();
        String registrationNumber = buffer.readBoolean() ? buffer.m_130277_() : null;
        String showName = buffer.readBoolean() ? buffer.m_130277_() : null;
        PlayerSimple registeredByPlayer = buffer.readBoolean() ? PlayerSerializer.deserializePlayerSimple(buffer) : null;
        Date registeredDate = buffer.readBoolean() ? buffer.m_130282_() : null;
        HorseRegistrationOrganizationInfo info2 = new HorseRegistrationOrganizationInfo(organization, horseId, registrationNumber, showName, registeredByPlayer, registeredDate);
        return new ClientBoundHorseRegistrationOrganizationMenuOpenPacket(info2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseRegistrationOrganizationMenu.showMenu(this.info));
    }
}

