/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.sale.log.HorseSaleInfo;
import com.equestricraft.core.horse.sale.log.HorseSalePage;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.horse.sale.HorseSaleHistoryMenu;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseSaleHistoryOpenPacket {
    private final HorseSimple horse;
    private final HorseSalePage page;

    public ClientBoundHorseSaleHistoryOpenPacket(HorseSimple horse, HorseSalePage page) {
        this.horse = horse;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.page.getItems().size());
        for (HorseSaleInfo item : this.page.getItems()) {
            buffer.writeInt(item.id());
            PlayerSerializer.serializePlayerSimple(item.player(), buffer);
            buffer.writeLong(item.timeStamp());
            buffer.m_130070_(item.value());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundHorseSaleHistoryOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int itemsCount = buffer.readInt();
        ArrayList<HorseSaleInfo> items = new ArrayList<HorseSaleInfo>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            int id = buffer.readInt();
            PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
            long timeStamp = buffer.readLong();
            String value = buffer.m_130277_();
            HorseSaleInfo item = new HorseSaleInfo(id, player, timeStamp, value);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        HorseSalePage page = new HorseSalePage((List<HorseSaleInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundHorseSaleHistoryOpenPacket(horse, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseSaleHistoryMenu.showMenu(this.horse, this.page));
    }
}

