/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.sale.PreSaleInfo;
import com.equestricraft.core.horse.stud.StudRegistrationStatus;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.horse.HorseSellMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseSellMenuOpenPacket {
    private final PreSaleInfo preSaleInfo;

    public ClientBoundHorseSellMenuOpenPacket(PreSaleInfo preSaleInfo) {
        this.preSaleInfo = preSaleInfo;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.preSaleInfo.horseId());
        if (this.preSaleInfo.showName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.preSaleInfo.showName());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130070_(this.preSaleInfo.value());
        buffer.writeBoolean(this.preSaleInfo.pregnant());
        if (this.preSaleInfo.foalOwner() != null) {
            buffer.writeBoolean(true);
            PlayerSerializer.serializePlayerSimple(this.preSaleInfo.foalOwner(), buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130068_((Enum)this.preSaleInfo.health());
        buffer.m_130070_(this.preSaleInfo.ageDisplay());
        buffer.m_130068_((Enum)this.preSaleInfo.studRegistrationStatus());
        PlayerSerializer.serializePlayerSimple(this.preSaleInfo.sellingPlayer(), buffer);
        buffer.m_130070_(this.preSaleInfo.breed());
    }

    public static ClientBoundHorseSellMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        String showName = buffer.readBoolean() ? buffer.m_130277_() : null;
        String value = buffer.m_130277_();
        boolean pregnant = buffer.readBoolean();
        PlayerSimple foalOwner = buffer.readBoolean() ? PlayerSerializer.deserializePlayerSimple(buffer) : null;
        HorseHealth healthStatus = (HorseHealth)buffer.m_130066_(HorseHealth.class);
        String ageDisplay = buffer.m_130277_();
        StudRegistrationStatus studRegistrationStatus = (StudRegistrationStatus)buffer.m_130066_(StudRegistrationStatus.class);
        PlayerSimple sellingPlayer = PlayerSerializer.deserializePlayerSimple(buffer);
        String breed = buffer.m_130277_();
        PreSaleInfo preSaleInfo = new PreSaleInfo(horseId, showName, value, pregnant, foalOwner, healthStatus, ageDisplay, studRegistrationStatus, sellingPlayer, breed);
        return new ClientBoundHorseSellMenuOpenPacket(preSaleInfo);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseSellMenuScreen.showScreen(this.preSaleInfo));
    }
}

