/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.skill.SkillSimple;
import com.equestricraft.mod.client.gui.horse.skill.HorseSkillListScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseSkillMenuOpenPacket {
    private final HorseSimple horse;
    private final List<SkillSimple> skills;

    public ClientBoundHorseSkillMenuOpenPacket(HorseSimple horse, List<SkillSimple> skills) {
        this.horse = horse;
        this.skills = skills;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.skills.size());
        for (SkillSimple skill : this.skills) {
            buffer.writeInt(skill.id());
            buffer.m_130070_(skill.name());
            buffer.m_130070_(skill.description());
        }
    }

    public static ClientBoundHorseSkillMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int amount = buffer.readInt();
        ArrayList<SkillSimple> skills = new ArrayList<SkillSimple>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            SkillSimple skill = new SkillSimple(id, name, description);
            skills.add(skill);
        }
        return new ClientBoundHorseSkillMenuOpenPacket(horse, skills);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseSkillListScreen.showMenu(this.horse, this.skills));
    }
}

