/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.information.HorseStatsInformation;
import com.equestricraft.core.horse.stats.HorseStat;
import com.equestricraft.mod.client.gui.horse.HorseStatsScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseStatsMenuOpenPacket {
    private final HorseSimple horse;
    private final HorseStatsInformation stats;

    public ClientBoundHorseStatsMenuOpenPacket(HorseSimple horse, HorseStatsInformation stats) {
        this.horse = horse;
        this.stats = stats;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        this.writeStat(buffer, this.stats.walkSpeed());
        this.writeStat(buffer, this.stats.trotSpeed());
        this.writeStat(buffer, this.stats.canterSpeed());
        this.writeStat(buffer, this.stats.gallopSpeed());
        this.writeStat(buffer, this.stats.jumpPower());
        buffer.writeLong(this.stats.currentMaximumStamina());
        buffer.writeLong(this.stats.baseMaximumStamina());
        buffer.writeDouble(this.stats.intelligence());
        buffer.writeDouble(this.stats.memory());
        buffer.writeDouble(this.stats.aggression());
        buffer.writeDouble(this.stats.appetite());
        buffer.writeDouble(this.stats.obedience());
        buffer.writeDouble(this.stats.restlessness());
        buffer.writeDouble(this.stats.spookiness());
        buffer.writeDouble(this.stats.frustration());
        buffer.writeDouble(this.stats.stress());
    }

    private void writeStat(FriendlyByteBuf buffer, HorseStat stat) {
        buffer.writeFloat(stat.baseValue());
        buffer.writeFloat(stat.value());
    }

    public static ClientBoundHorseStatsMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        HorseStat walkSpeed = ClientBoundHorseStatsMenuOpenPacket.readStat(buffer);
        HorseStat trotSpeed = ClientBoundHorseStatsMenuOpenPacket.readStat(buffer);
        HorseStat canterSpeed = ClientBoundHorseStatsMenuOpenPacket.readStat(buffer);
        HorseStat gallopSpeed = ClientBoundHorseStatsMenuOpenPacket.readStat(buffer);
        HorseStat jumpPower = ClientBoundHorseStatsMenuOpenPacket.readStat(buffer);
        long currentMaximumStamina = buffer.readLong();
        long baseMaximumStamina = buffer.readLong();
        double intelligence = buffer.readDouble();
        double memory = buffer.readDouble();
        double aggression = buffer.readDouble();
        double appetite = buffer.readDouble();
        double obedience = buffer.readDouble();
        double restlessness = buffer.readDouble();
        double spookiness = buffer.readDouble();
        double frustration = buffer.readDouble();
        double stress = buffer.readDouble();
        HorseStatsInformation stats = new HorseStatsInformation(walkSpeed, trotSpeed, canterSpeed, gallopSpeed, jumpPower, currentMaximumStamina, baseMaximumStamina, intelligence, memory, aggression, appetite, obedience, restlessness, spookiness, frustration, stress);
        return new ClientBoundHorseStatsMenuOpenPacket(horse, stats);
    }

    private static HorseStat readStat(FriendlyByteBuf buffer) {
        float baseSpeed = buffer.readFloat();
        float value = buffer.readFloat();
        return new HorseStat(baseSpeed, value);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseStatsScreen.showHorseDataMenu(this.horse, this.stats));
    }
}

