/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.stud.StudRegistrationStatus;
import com.equestricraft.mod.client.gui.studregister.HorseStudRegisterMenu;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseStudRegisterMenuOpenPacket {
    private final Integer horseId;
    private final int registryId;
    private final String name;
    private final StudRegistrationStatus status;

    public ClientBoundHorseStudRegisterMenuOpenPacket(Integer horseId, int registryId, String name, StudRegistrationStatus status) {
        this.horseId = horseId;
        this.registryId = registryId;
        this.name = name;
        this.status = status;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.horseId != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.horseId.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.registryId);
        buffer.m_130070_(this.name);
        if (this.status != null) {
            buffer.writeBoolean(true);
            buffer.m_130068_((Enum)this.status);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundHorseStudRegisterMenuOpenPacket decode(FriendlyByteBuf buffer) {
        Integer horseId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        int registryId = buffer.readInt();
        String name = buffer.m_130277_();
        StudRegistrationStatus status = buffer.readBoolean() ? (StudRegistrationStatus)buffer.m_130066_(StudRegistrationStatus.class) : null;
        return new ClientBoundHorseStudRegisterMenuOpenPacket(horseId, registryId, name, status);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseStudRegisterMenu.showScreen(this.horseId, this.registryId, this.name, this.status));
    }
}

