/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.illness.IllnessSymptomInformation;
import com.equestricraft.mod.client.gui.horse.illness.HorseIllnessSymptomScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseSymptomsViewMenuOpenPacket {
    private final HorseSimple horse;
    private final List<IllnessSymptomInformation> symptoms;

    public ClientBoundHorseSymptomsViewMenuOpenPacket(HorseSimple horse, List<IllnessSymptomInformation> symptoms) {
        this.horse = horse;
        this.symptoms = symptoms;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.symptoms.size());
        for (IllnessSymptomInformation symptom : this.symptoms) {
            buffer.m_130070_(symptom.name());
            buffer.m_130070_(symptom.description());
        }
    }

    public static ClientBoundHorseSymptomsViewMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int symptomCount = buffer.readInt();
        ArrayList<IllnessSymptomInformation> symptomDescriptions = new ArrayList<IllnessSymptomInformation>(symptomCount);
        for (int i = 0; i < symptomCount; ++i) {
            String symptomName = buffer.m_130277_();
            String symptomDescription = buffer.m_130277_();
            IllnessSymptomInformation symptom = new IllnessSymptomInformation(symptomName, symptomDescription);
            symptomDescriptions.add(symptom);
        }
        return new ClientBoundHorseSymptomsViewMenuOpenPacket(horse, symptomDescriptions);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseIllnessSymptomScreen.showHorseSymptomsMenu(this.horse, this.symptoms));
    }
}

