/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.tack.TackType;
import com.equestricraft.core.tack.TackInfo;
import com.equestricraft.core.tack.TackTypeInfo;
import com.equestricraft.mod.client.gui.horse.tack.HorseTackMenuMain;
import com.equestricraft.mod.horse.tack.HorseTackTypeInfo;
import com.equestricraft.mod.horse.tack.TackTypesInfo;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseTackMenuOpenPacket {
    private final int horseId;
    private final TackTypesInfo types;

    public ClientBoundHorseTackMenuOpenPacket(int horseId, TackTypesInfo types) {
        this.horseId = horseId;
        this.types = types;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        this.writeTackInfo(this.types.bonnet(), buffer);
        this.writeTackInfo(this.types.boots(), buffer);
        this.writeTackInfo(this.types.bridle(), buffer);
        this.writeTackInfo(this.types.cinch(), buffer);
        this.writeTackInfo(this.types.girth(), buffer);
        this.writeTackInfo(this.types.halter(), buffer);
        this.writeTackInfo(this.types.pad(), buffer);
        this.writeTackInfo(this.types.rein(), buffer);
        this.writeTackInfo(this.types.saddle(), buffer);
        this.writeTackInfo(this.types.wraps(), buffer);
    }

    private void writeTackInfo(HorseTackTypeInfo typeInfo, FriendlyByteBuf buffer) {
        buffer.m_130070_(typeInfo.type().name());
        buffer.m_130070_(typeInfo.type().label());
        buffer.m_130068_((Enum)typeInfo.type().type());
        if (typeInfo.tack() != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(typeInfo.tack().id());
            buffer.m_130070_(typeInfo.tack().label());
            buffer.m_130070_(typeInfo.tack().description());
            buffer.m_130070_(typeInfo.tack().type().name());
            buffer.m_130070_(typeInfo.tack().type().label());
            buffer.m_130068_((Enum)typeInfo.tack().type().type());
            buffer.m_130077_(typeInfo.itemId());
            buffer.writeDouble(typeInfo.condition().doubleValue());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundHorseTackMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        HorseTackTypeInfo bonnet = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo boots = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo bridle = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo cinch = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo girth = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo halter = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo pad = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo rein = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo saddle = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        HorseTackTypeInfo wraps = ClientBoundHorseTackMenuOpenPacket.readTackInfo(buffer);
        TackTypesInfo types = new TackTypesInfo(bonnet, boots, bridle, cinch, girth, halter, pad, rein, saddle, wraps);
        return new ClientBoundHorseTackMenuOpenPacket(horseId, types);
    }

    private static HorseTackTypeInfo readTackInfo(FriendlyByteBuf buffer) {
        Double condition;
        UUID itemId;
        TackInfo tackInfo;
        String name = buffer.m_130277_();
        String label = buffer.m_130277_();
        TackType type = (TackType)buffer.m_130066_(TackType.class);
        TackTypeInfo typeInfo = new TackTypeInfo(name, label, type);
        if (buffer.readBoolean()) {
            int id = buffer.readInt();
            String tackLabel = buffer.m_130277_();
            String tackDescription = buffer.m_130277_();
            String typeName = buffer.m_130277_();
            String typeLabel = buffer.m_130277_();
            TackType typeType = (TackType)buffer.m_130066_(TackType.class);
            TackTypeInfo tackTypeInfo = new TackTypeInfo(typeName, typeLabel, typeType);
            tackInfo = new TackInfo(id, tackLabel, tackDescription, tackTypeInfo);
            itemId = buffer.m_130259_();
            condition = buffer.readDouble();
        } else {
            tackInfo = null;
            itemId = null;
            condition = null;
        }
        return new HorseTackTypeInfo(typeInfo, tackInfo, itemId, condition);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseTackMenuMain.showMenu(this.horseId, this.types));
    }
}

