/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.information.HorseBasicViewDetails;
import com.equestricraft.mod.client.gui.horse.HorseMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseViewMenuOpenPacket {
    private final int horseId;
    private final HorseBasicViewDetails details;

    public ClientBoundHorseViewMenuOpenPacket(int horseId, HorseBasicViewDetails details) {
        this.horseId = horseId;
        this.details = details;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.m_130070_(this.details.name());
        if (this.details.showName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.details.showName());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.details.owner() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.details.owner());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130070_(this.details.gender());
        buffer.m_130070_(this.details.age());
        buffer.m_130070_(this.details.breed());
        buffer.m_130068_((Enum)this.details.health());
        buffer.writeBoolean(this.details.hasParents());
        buffer.writeBoolean(this.details.disciplinesCertified());
        if (this.details.lastRideTime() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.details.lastRideTime());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(this.details.pregnancyConfirmed());
        buffer.writeBoolean(this.details.stallRest());
        buffer.m_130070_(this.details.status());
    }

    public static ClientBoundHorseViewMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        String horseName = buffer.m_130277_();
        String showName = buffer.readBoolean() ? buffer.m_130277_() : null;
        String ownerName = buffer.readBoolean() ? buffer.m_130277_() : null;
        String gender = buffer.m_130277_();
        String age = buffer.m_130277_();
        String breed = buffer.m_130277_();
        HorseHealth health = (HorseHealth)buffer.m_130066_(HorseHealth.class);
        boolean hasParents = buffer.readBoolean();
        boolean disciplinesCertified = buffer.readBoolean();
        String lastRideTime = buffer.readBoolean() ? buffer.m_130277_() : null;
        boolean pregnancyConfirmed = buffer.readBoolean();
        boolean stallRest = buffer.readBoolean();
        String status = buffer.m_130277_();
        HorseBasicViewDetails details = new HorseBasicViewDetails(horseName, showName, ownerName, gender, age, breed, health, hasParents, disciplinesCertified, lastRideTime, pregnancyConfirmed, stallRest, status);
        return new ClientBoundHorseViewMenuOpenPacket(horseId, details);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseMenuScreen.showHorseMainMenu(this.horseId, this.details));
    }
}

