/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.information.HorseVitaminInformation;
import com.equestricraft.core.horse.nutrient.HorseNutrientStatus;
import com.equestricraft.mod.client.gui.horse.vitamin.HorseVitaminScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseVitaminViewMenuOpenPacket {
    private final HorseSimple horse;
    private final List<HorseVitaminInformation> vitamins;

    public ClientBoundHorseVitaminViewMenuOpenPacket(HorseSimple horse, List<HorseVitaminInformation> vitamins) {
        this.horse = horse;
        this.vitamins = vitamins;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.vitamins.size());
        for (HorseVitaminInformation info2 : this.vitamins) {
            buffer.m_130070_(info2.name());
            buffer.writeDouble(info2.value());
            buffer.m_130070_(info2.displayValue());
            buffer.m_130068_((Enum)info2.status());
        }
    }

    public static ClientBoundHorseVitaminViewMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int amount = buffer.readInt();
        ArrayList<HorseVitaminInformation> list = new ArrayList<HorseVitaminInformation>(amount);
        for (int i = 0; i < amount; ++i) {
            String name = buffer.m_130277_();
            double value = buffer.readDouble();
            String displayValue = buffer.m_130277_();
            HorseNutrientStatus status = (HorseNutrientStatus)buffer.m_130066_(HorseNutrientStatus.class);
            HorseVitaminInformation info2 = new HorseVitaminInformation(name, value, displayValue, status);
            list.add(info2);
        }
        return new ClientBoundHorseVitaminViewMenuOpenPacket(horse, list);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseVitaminScreen.showHorseVitaminsMenu(this.horse, this.vitamins));
    }
}

