/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.weight.HorseWeightLogEntry;
import com.equestricraft.core.horse.weight.HorseWeightPage;
import com.equestricraft.mod.client.gui.horse.weight.HorseWeightLogScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseWeightLogOpenPacket {
    private final HorseSimple horse;
    private final HorseWeightPage page;

    public ClientBoundHorseWeightLogOpenPacket(HorseSimple horse, HorseWeightPage page) {
        this.horse = horse;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.page.getItems().size());
        for (HorseWeightLogEntry item : this.page.getItems()) {
            buffer.writeDouble(item.weight());
            buffer.m_130075_(item.timeStamp());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundHorseWeightLogOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int itemsCount = buffer.readInt();
        ArrayList<HorseWeightLogEntry> items = new ArrayList<HorseWeightLogEntry>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            double weight = buffer.readDouble();
            Date timeStamp = buffer.m_130282_();
            HorseWeightLogEntry item = new HorseWeightLogEntry(weight, timeStamp);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        HorseWeightPage page = new HorseWeightPage((List<HorseWeightLogEntry>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundHorseWeightLogOpenPacket(horse, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseWeightLogScreen.showScreen(this.horse, this.page));
    }
}

