/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.information.HorseWelfareInformation;
import com.equestricraft.mod.client.gui.horse.HorseWelfareScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundHorseWelfareMenuOpenPacket {
    private final HorseSimple horse;
    private final HorseWelfareInformation health;

    public ClientBoundHorseWelfareMenuOpenPacket(HorseSimple horse, HorseWelfareInformation health) {
        this.horse = horse;
        this.health = health;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        if (this.health.fullnessPercentage() != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.health.fullnessPercentage().intValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.health.hydrationPercentage() != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.health.hydrationPercentage().intValue());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130068_((Enum)this.health.horseHealth());
        buffer.writeBoolean(this.health.hasIllnessesToShow());
        buffer.writeBoolean(this.health.hasVisibleSymptoms());
        buffer.writeBoolean(this.health.hasVisibleMedicines());
        buffer.writeBoolean(this.health.canViewVitamins());
        if (this.health.bloodType() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.health.bloodType());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(this.health.wormerActive());
        buffer.writeInt(this.health.hoofLengthPercentage());
        buffer.writeInt(this.health.hoofCleanPercentage());
        buffer.writeInt(this.health.cleanPercentage());
        buffer.writeBoolean(this.health.dailyCareComplete());
        buffer.writeBoolean(this.health.inHeat());
    }

    public static ClientBoundHorseWelfareMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        Integer hungerStatus = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        Integer thirstStatus = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        HorseHealth health = (HorseHealth)buffer.m_130066_(HorseHealth.class);
        boolean hasIllnessesToShow = buffer.readBoolean();
        boolean hasVisibleSymptoms = buffer.readBoolean();
        boolean hasVisibleMedicines = buffer.readBoolean();
        boolean canViewVitamins = buffer.readBoolean();
        String bloodType = buffer.readBoolean() ? buffer.m_130277_() : null;
        boolean wormerActive = buffer.readBoolean();
        int hoofLengthPercentage = buffer.readInt();
        int hoofCleanPercentage = buffer.readInt();
        int cleanPercentage = buffer.readInt();
        boolean dailyCareComplete = buffer.readBoolean();
        boolean inHeat = buffer.readBoolean();
        HorseWelfareInformation healthInformation = new HorseWelfareInformation(hungerStatus, thirstStatus, health, hasIllnessesToShow, hasVisibleSymptoms, hasVisibleMedicines, canViewVitamins, bloodType, wormerActive, hoofLengthPercentage, hoofCleanPercentage, cleanPercentage, dailyCareComplete, inHeat);
        return new ClientBoundHorseWelfareMenuOpenPacket(horse, healthInformation);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseWelfareScreen.showMenu(this.horse, this.health));
    }
}

