/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.MapUtils;
import com.equestricraft.mod.i18n.I18nDto;
import com.equestricraft.mod.i18n.I18nPrefixDto;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundI18nDataPacket {
    private final List<I18nDto> i18nDtoList;
    private final List<I18nPrefixDto> i18nPrefixDtoList;

    public ClientBoundI18nDataPacket(List<I18nDto> i18nDtoList, List<I18nPrefixDto> i18nPrefixDtoList) {
        this.i18nDtoList = i18nDtoList;
        this.i18nPrefixDtoList = i18nPrefixDtoList;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.i18nDtoList.size());
        for (I18nDto i18nDto : this.i18nDtoList) {
            buffer.m_130070_(i18nDto.key());
            buffer.m_130070_(i18nDto.value());
        }
        buffer.writeInt(this.i18nPrefixDtoList.size());
        for (I18nPrefixDto i18nPrefixDto : this.i18nPrefixDtoList) {
            buffer.m_130070_(i18nPrefixDto.pattern());
            buffer.m_130070_(i18nPrefixDto.value());
        }
    }

    public static ClientBoundI18nDataPacket decode(FriendlyByteBuf buffer) {
        int i18nAmount = buffer.readInt();
        ArrayList<I18nDto> i18nDtoList = new ArrayList<I18nDto>(i18nAmount);
        for (int i = 0; i < i18nAmount; ++i) {
            String key = buffer.m_130277_();
            String value = buffer.m_130277_();
            i18nDtoList.add(new I18nDto(key, value));
        }
        int i18nPrefixAmount = buffer.readInt();
        ArrayList<I18nPrefixDto> i18nPrefixDtoList = new ArrayList<I18nPrefixDto>(i18nPrefixAmount);
        for (int i = 0; i < i18nPrefixAmount; ++i) {
            String pattern = buffer.m_130277_();
            String value = buffer.m_130277_();
            i18nPrefixDtoList.add(new I18nPrefixDto(pattern, value));
        }
        return new ClientBoundI18nDataPacket(i18nDtoList, i18nPrefixDtoList);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            I18n i18n = I18n.getI18n();
            i18n.setResourceMap(MapUtils.createMap(this.i18nDtoList, I18nDto::key, I18nDto::value));
            i18n.setPrefixMap(MapUtils.createMap(this.i18nPrefixDtoList, I18nPrefixDto::pattern, I18nPrefixDto::value));
        });
    }
}

