/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.gui.ImageDisplay;
import com.equestricraft.mod.packet.PacketUtil;
import java.awt.image.BufferedImage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundImageDisplayOpenPacket {
    private final String title;
    private final BufferedImage image;

    public ClientBoundImageDisplayOpenPacket(String title, BufferedImage image) {
        this.title = title;
        this.image = image;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.title);
        buffer.writeInt(this.image.getWidth());
        buffer.writeInt(this.image.getHeight());
        buffer.writeInt(this.image.getType());
        for (int x = 0; x < this.image.getWidth(); ++x) {
            for (int y = 0; y < this.image.getHeight(); ++y) {
                buffer.writeInt(this.image.getRGB(x, y));
            }
        }
    }

    public static ClientBoundImageDisplayOpenPacket decode(FriendlyByteBuf buffer) {
        String title = buffer.m_130277_();
        int width = buffer.readInt();
        int height = buffer.readInt();
        int type = buffer.readInt();
        BufferedImage image = new BufferedImage(width, height, type);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, buffer.readInt());
            }
        }
        return new ClientBoundImageDisplayOpenPacket(title, image);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ImageDisplay.showImage(this.title, this.image));
    }
}

