/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.quest.menu.QuestInProgressMenuItem;
import com.equestricraft.mod.client.gui.quest.QuestInProgressMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundInProgressQuestsMenuOpenPacket {
    private final List<QuestInProgressMenuItem> quests;

    public ClientBoundInProgressQuestsMenuOpenPacket(List<QuestInProgressMenuItem> quests) {
        this.quests = quests;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.quests.size());
        for (QuestInProgressMenuItem quest : this.quests) {
            buffer.writeInt(quest.getId());
            buffer.m_130070_(quest.getTitle());
            buffer.writeInt(quest.getObjectives().size());
            for (String objective : quest.getObjectives()) {
                buffer.m_130070_(objective);
            }
        }
    }

    public static ClientBoundInProgressQuestsMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<QuestInProgressMenuItem> quests = new ArrayList<QuestInProgressMenuItem>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            int questObjectivesCount = buffer.readInt();
            ArrayList<String> questObjectives = new ArrayList<String>(questObjectivesCount);
            for (int j = 0; j < questObjectivesCount; ++j) {
                questObjectives.add(buffer.m_130277_());
            }
            QuestInProgressMenuItem quest = new QuestInProgressMenuItem(id, name, questObjectives);
            quests.add(quest);
        }
        return new ClientBoundInProgressQuestsMenuOpenPacket(quests);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> QuestInProgressMenuScreen.showScreen(this.quests));
    }
}

