/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.job.JobSimple;
import com.equestricraft.core.job.request.JobRequestInfo;
import com.equestricraft.core.job.request.JobRequestPage;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.job.JobRequestsPageScreen;
import com.equestricraft.mod.job.JobSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundJobAvailableRequestsMenuOpenPacket {
    private final JobSimple job;
    private final JobRequestPage page;

    public ClientBoundJobAvailableRequestsMenuOpenPacket(JobSimple job, JobRequestPage page) {
        this.job = job;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        JobSerializer.serialize(this.job, buffer);
        buffer.writeInt(this.page.getItems().size());
        for (JobRequestInfo item : this.page.getItems()) {
            buffer.writeInt(item.id());
            PlayerSerializer.serializePlayerSimple(item.requester(), buffer);
            buffer.writeInt(item.horseId());
            buffer.m_130070_(item.description());
            buffer.writeLong(item.createdTime());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundJobAvailableRequestsMenuOpenPacket decode(FriendlyByteBuf buffer) {
        JobSimple job = JobSerializer.deserialize(buffer);
        int amount = buffer.readInt();
        ArrayList<JobRequestInfo> items = new ArrayList<JobRequestInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            PlayerSimple requester = PlayerSerializer.deserializePlayerSimple(buffer);
            int horseId = buffer.readInt();
            String description = buffer.m_130277_();
            long createdTime = buffer.readLong();
            JobRequestInfo item = new JobRequestInfo(id, requester, horseId, description, createdTime);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        JobRequestPage page = new JobRequestPage((List<JobRequestInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundJobAvailableRequestsMenuOpenPacket(job, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> JobRequestsPageScreen.showScreen(this.job, this.page));
    }
}

