/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.job.JobSimple;
import com.equestricraft.core.job.invoice.JobInvoiceInfo;
import com.equestricraft.core.job.invoice.JobInvoiceStatus;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.job.JobInvoiceListScreen;
import com.equestricraft.mod.job.JobSerializer;
import com.equestricraft.mod.job.activework.JobInvoicePage;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundJobInvoicesMenuOpenPacket {
    private final JobInvoicePage page;

    public ClientBoundJobInvoicesMenuOpenPacket(JobInvoicePage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (JobInvoiceInfo item : this.page.getItems()) {
            buffer.writeInt(item.invoiceId());
            buffer.m_130070_(item.title());
            PlayerSerializer.serializePlayerSimple(item.toPlayer(), buffer);
            PlayerSerializer.serializePlayerSimple(item.fromPlayer(), buffer);
            JobSerializer.serialize(item.job(), buffer);
            buffer.writeDouble(item.paymentValue());
            buffer.m_130070_(item.paymentValueFormatted());
            buffer.m_130070_(item.description());
            buffer.m_130075_(item.time());
            buffer.m_130068_((Enum)item.status());
            buffer.writeBoolean(item.overdue());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundJobInvoicesMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<JobInvoiceInfo> items = new ArrayList<JobInvoiceInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int invoiceId = buffer.readInt();
            String title = buffer.m_130277_();
            PlayerSimple toPlayer = PlayerSerializer.deserializePlayerSimple(buffer);
            PlayerSimple fromPlayer = PlayerSerializer.deserializePlayerSimple(buffer);
            JobSimple job = JobSerializer.deserialize(buffer);
            double paymentValue = buffer.readDouble();
            String paymentValueFormatted = buffer.m_130277_();
            String description = buffer.m_130277_();
            Date time = buffer.m_130282_();
            JobInvoiceStatus status = (JobInvoiceStatus)buffer.m_130066_(JobInvoiceStatus.class);
            boolean overdue = buffer.readBoolean();
            JobInvoiceInfo item = new JobInvoiceInfo(invoiceId, title, toPlayer, fromPlayer, job, paymentValue, paymentValueFormatted, description, time, status, overdue);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        JobInvoicePage page = new JobInvoicePage((List<JobInvoiceInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundJobInvoicesMenuOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> JobInvoiceListScreen.showScreen(this.page));
    }
}

