/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.job.JobMembersScreen;
import com.equestricraft.mod.job.JobMemberInfo;
import com.equestricraft.mod.job.JobScreenPage;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundJobMembersListOpenPacket {
    private final int jobId;
    private final String jobName;
    private final JobScreenPage jobScreenPage;

    public ClientBoundJobMembersListOpenPacket(int jobId, String jobName, JobScreenPage jobScreenPage) {
        this.jobId = jobId;
        this.jobName = jobName;
        this.jobScreenPage = jobScreenPage;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.jobId);
        buffer.m_130070_(this.jobName);
        buffer.writeInt(this.jobScreenPage.getItems().size());
        for (JobMemberInfo member : this.jobScreenPage.getItems()) {
            PlayerSerializer.serializePlayerSimple(member.player(), buffer);
            buffer.m_130070_(member.position());
            buffer.writeBoolean(member.online());
        }
        buffer.writeInt(this.jobScreenPage.getPageNumber());
        buffer.writeInt(this.jobScreenPage.getTotalPages());
    }

    public static ClientBoundJobMembersListOpenPacket decode(FriendlyByteBuf buffer) {
        int jobId = buffer.readInt();
        String jobName = buffer.m_130277_();
        int membersCount = buffer.readInt();
        ArrayList<JobMemberInfo> members = new ArrayList<JobMemberInfo>(membersCount);
        for (int i = 0; i < membersCount; ++i) {
            PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
            String position = buffer.m_130277_();
            boolean online = buffer.readBoolean();
            JobMemberInfo member = new JobMemberInfo(player, position, online);
            members.add(member);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        JobScreenPage jobScreenInfo = new JobScreenPage((List<JobMemberInfo>)members, pageNumber, totalPages, SortDirection.ASCENDING, (Object)null, (Object)null);
        return new ClientBoundJobMembersListOpenPacket(jobId, jobName, jobScreenInfo);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> JobMembersScreen.showJobMembersScreen(this.jobId, this.jobName, this.jobScreenPage));
    }
}

