/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.job.JobInfo;
import com.equestricraft.mod.client.gui.job.JobMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundJobMenuScreenOpenPacket {
    private final JobInfo jobInfo;

    public ClientBoundJobMenuScreenOpenPacket(JobInfo jobInfo) {
        this.jobInfo = jobInfo;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.jobInfo.id());
        buffer.m_130070_(this.jobInfo.identifier());
        buffer.m_130070_(this.jobInfo.name());
        buffer.m_130070_(this.jobInfo.description());
        buffer.writeInt(this.jobInfo.heads().size());
        for (String head : this.jobInfo.heads()) {
            buffer.m_130070_(head);
        }
    }

    public static ClientBoundJobMenuScreenOpenPacket decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        String identifier = buffer.m_130277_();
        String name = buffer.m_130277_();
        String description = buffer.m_130277_();
        int headsCount = buffer.readInt();
        ArrayList<String> heads = new ArrayList<String>(headsCount);
        for (int i = 0; i < headsCount; ++i) {
            heads.add(buffer.m_130277_());
        }
        JobInfo jobInfo = new JobInfo(id, identifier, name, description, heads);
        return new ClientBoundJobMenuScreenOpenPacket(jobInfo);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> JobMenuScreen.showScreen(this.jobInfo));
    }
}

