/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.Argb;
import com.equestricraft.core.horse.jobwork.JobWorkCheckInfo;
import com.equestricraft.mod.client.gui.horse.jobwork.JobWorkScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundJobWorkScreenOpenPacket {
    private final String jobName;
    private final List<JobWorkCheckInfo> workList;

    public ClientBoundJobWorkScreenOpenPacket(String jobName, List<JobWorkCheckInfo> workList) {
        this.jobName = jobName;
        this.workList = workList;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.jobName);
        buffer.writeInt(this.workList.size());
        for (JobWorkCheckInfo work : this.workList) {
            buffer.m_130077_(work.workId());
            buffer.m_130070_(work.name());
            buffer.m_130070_(work.description());
            buffer.m_130070_(work.status());
            if (work.statusColor() != null) {
                buffer.writeBoolean(true);
                buffer.writeInt(work.statusColor().getIntValue());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(work.flagged());
        }
    }

    public static ClientBoundJobWorkScreenOpenPacket decode(FriendlyByteBuf buffer) {
        String jobName = buffer.m_130277_();
        int amount = buffer.readInt();
        ArrayList<JobWorkCheckInfo> infoList = new ArrayList<JobWorkCheckInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            UUID id = buffer.m_130259_();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            String status = buffer.m_130277_();
            Argb statusColor = buffer.readBoolean() ? Argb.fromIntValue(buffer.readInt()) : null;
            boolean flagged = buffer.readBoolean();
            JobWorkCheckInfo info2 = new JobWorkCheckInfo(id, name, description, status, statusColor, flagged);
            infoList.add(info2);
        }
        return new ClientBoundJobWorkScreenOpenPacket(jobName, infoList);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> JobWorkScreen.showScreen(this.jobName, this.workList));
    }
}

