/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.Argb;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.job.JobSimple;
import com.equestricraft.mod.client.gui.horse.jobwork.JobsNeedingWorkScreen;
import com.equestricraft.mod.horse.HorseSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundJobsNeedingWorkMenuOpenPacket {
    private final HorseSimple horse;
    private final List<JobSimple> jobs;

    public ClientBoundJobsNeedingWorkMenuOpenPacket(HorseSimple horse, List<JobSimple> jobs) {
        this.horse = horse;
        this.jobs = jobs;
    }

    public void encode(FriendlyByteBuf buffer) {
        HorseSerializer.serializeHorse(this.horse, buffer);
        buffer.writeInt(this.jobs.size());
        for (JobSimple job : this.jobs) {
            buffer.writeInt(job.id());
            buffer.m_130070_(job.name());
            buffer.m_130070_(job.identifier());
            buffer.m_130070_(job.chatTag());
            buffer.writeInt(job.color().getIntValue());
        }
    }

    public static ClientBoundJobsNeedingWorkMenuOpenPacket decode(FriendlyByteBuf buffer) {
        HorseSimple horse = HorseSerializer.deserializeHorse(buffer);
        int amount = buffer.readInt();
        ArrayList<JobSimple> list = new ArrayList<JobSimple>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String identifier = buffer.m_130277_();
            String chatTag = buffer.m_130277_();
            Argb color = Argb.fromIntValue(buffer.readInt());
            JobSimple jobSimple = new JobSimple(id, name, identifier, chatTag, color);
            list.add(jobSimple);
        }
        return new ClientBoundJobsNeedingWorkMenuOpenPacket(horse, list);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> JobsNeedingWorkScreen.showScreen(this.horse, this.jobs));
    }
}

