/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.leaderboard.LeaderboardSimpleInfo;
import com.equestricraft.mod.client.gui.leaderboard.LeaderboardListScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundLeaderboardListScreenOpenPacket {
    private final List<LeaderboardSimpleInfo> leaderboards;

    public ClientBoundLeaderboardListScreenOpenPacket(List<LeaderboardSimpleInfo> leaderboards) {
        this.leaderboards = leaderboards;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.leaderboards.size());
        for (LeaderboardSimpleInfo leaderboard : this.leaderboards) {
            buffer.writeInt(leaderboard.leaderboardId());
            buffer.m_130070_(leaderboard.leaderboardName());
        }
    }

    public static ClientBoundLeaderboardListScreenOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<LeaderboardSimpleInfo> leaderboards = new ArrayList<LeaderboardSimpleInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            LeaderboardSimpleInfo leaderboard = new LeaderboardSimpleInfo(id, name);
            leaderboards.add(leaderboard);
        }
        return new ClientBoundLeaderboardListScreenOpenPacket(leaderboards);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> LeaderboardListScreen.showScreen(this.leaderboards));
    }
}

