/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.leaderboard.LeaderboardEntryInfo;
import com.equestricraft.core.leaderboard.LeaderboardInfo;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.leaderboard.LeaderboardScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundLeaderboardScreenOpenPacket {
    private final LeaderboardInfo leaderboardInfo;

    public ClientBoundLeaderboardScreenOpenPacket(LeaderboardInfo leaderboardInfo) {
        this.leaderboardInfo = leaderboardInfo;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.leaderboardInfo.id());
        buffer.m_130070_(this.leaderboardInfo.name());
        buffer.m_130070_(this.leaderboardInfo.description());
        buffer.m_130070_(this.leaderboardInfo.scoreLabel());
        buffer.writeInt(this.leaderboardInfo.entries().size());
        for (LeaderboardEntryInfo entry : this.leaderboardInfo.entries()) {
            buffer.writeInt(entry.position());
            PlayerSerializer.serializePlayerSimple(entry.player(), buffer);
            buffer.writeDouble(entry.score());
            buffer.writeLong(entry.timeStamp());
        }
    }

    public static ClientBoundLeaderboardScreenOpenPacket decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        String name = buffer.m_130277_();
        String description = buffer.m_130277_();
        String scoreLabel = buffer.m_130277_();
        int entriesCount = buffer.readInt();
        ArrayList<LeaderboardEntryInfo> entries = new ArrayList<LeaderboardEntryInfo>(entriesCount);
        for (int i = 0; i < entriesCount; ++i) {
            int position = buffer.readInt();
            PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
            double score = buffer.readDouble();
            long timeStamp = buffer.readLong();
            LeaderboardEntryInfo entry = new LeaderboardEntryInfo(position, player, score, timeStamp);
            entries.add(entry);
        }
        LeaderboardInfo info2 = new LeaderboardInfo(id, name, description, scoreLabel, entries);
        return new ClientBoundLeaderboardScreenOpenPacket(info2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> LeaderboardScreen.showScreen(this.leaderboardInfo));
    }
}

