/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.gui.horse.lineage.HorseLineageMenu;
import com.equestricraft.mod.horse.LineageNodeMenuItem;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundLineageMenuOpenPacket {
    private final LineageNodeMenuItem item;

    public ClientBoundLineageMenuOpenPacket(LineageNodeMenuItem item) {
        this.item = item;
    }

    public void encode(FriendlyByteBuf buffer) {
        this.encodeItem(this.item, buffer);
    }

    private void encodeItem(LineageNodeMenuItem item, FriendlyByteBuf buffer) {
        buffer.writeInt(item.horseId());
        buffer.m_130070_(item.horseName());
        buffer.writeBoolean(item.alive());
        if (item.corValue() != null) {
            buffer.writeBoolean(true);
            buffer.writeFloat(item.corValue().floatValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (item.hasParents()) {
            buffer.writeBoolean(true);
            this.encodeItem(item.mother(), buffer);
            this.encodeItem(item.father(), buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundLineageMenuOpenPacket decode(FriendlyByteBuf buffer) {
        LineageNodeMenuItem item = ClientBoundLineageMenuOpenPacket.decodeItem(buffer);
        return new ClientBoundLineageMenuOpenPacket(item);
    }

    private static LineageNodeMenuItem decodeItem(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        String horseName = buffer.m_130277_();
        boolean alive = buffer.readBoolean();
        Float corValue = buffer.readBoolean() ? Float.valueOf(buffer.readFloat()) : null;
        LineageNodeMenuItem mother = null;
        LineageNodeMenuItem father = null;
        if (buffer.readBoolean()) {
            mother = ClientBoundLineageMenuOpenPacket.decodeItem(buffer);
            father = ClientBoundLineageMenuOpenPacket.decodeItem(buffer);
        }
        return new LineageNodeMenuItem(horseId, horseName, alive, corValue, mother, father);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseLineageMenu.showHorseLineageMenu(this.item));
    }
}

