/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.season.SeasonType;
import com.equestricraft.core.global.GlobalContextInfo;
import com.equestricraft.core.player.PlayerContextInfo;
import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.mod.client.gui.MainMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import com.equestricraft.mod.weather.WeatherSerializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundMainMenuOpenPacket {
    private final GlobalContextInfo globalContextInfo;
    private final PlayerContextInfo playerContextInfo;
    private final String supportUrl;
    private final String discordUrl;
    private final String wikiUrl;

    public ClientBoundMainMenuOpenPacket(GlobalContextInfo globalContextInfo, PlayerContextInfo playerContextInfo, String supportUrl, String discordUrl, String wikiUrl) {
        this.globalContextInfo = globalContextInfo;
        this.playerContextInfo = playerContextInfo;
        this.supportUrl = supportUrl;
        this.discordUrl = discordUrl;
        this.wikiUrl = wikiUrl;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.globalContextInfo.currentSeason());
        WeatherSerializer.encodeCurrentWeather(this.globalContextInfo.currentWeather(), buffer);
        PlayerSerializer.serializePlayerContextInfo(this.playerContextInfo, buffer);
        buffer.m_130070_(this.supportUrl);
        buffer.m_130070_(this.discordUrl);
        buffer.m_130070_(this.wikiUrl);
    }

    public static ClientBoundMainMenuOpenPacket decode(FriendlyByteBuf buffer) {
        SeasonType currentSeason = (SeasonType)buffer.m_130066_(SeasonType.class);
        CurrentWeather currentWeather = WeatherSerializer.decodeCurrentWeather(buffer);
        GlobalContextInfo globalContextInfo = new GlobalContextInfo(currentSeason, currentWeather);
        PlayerContextInfo playerContextInfo = PlayerSerializer.deserializePlayerContextInfo(buffer);
        String supportUrl = buffer.m_130277_();
        String discordUrl = buffer.m_130277_();
        String wikiUrl = buffer.m_130277_();
        return new ClientBoundMainMenuOpenPacket(globalContextInfo, playerContextInfo, supportUrl, discordUrl, wikiUrl);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> MainMenuScreen.showScreen(this.globalContextInfo, this.playerContextInfo, this.supportUrl, this.discordUrl, this.wikiUrl));
    }
}

