/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.util.ComponentUtil;
import com.equestricraft.mod.util.TextItemUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundMessagePacket {
    private final TextItem item;

    public ClientBoundMessagePacket(TextItem item) {
        this.item = item;
    }

    public TextItem getItem() {
        return this.item;
    }

    public void encode(FriendlyByteBuf buffer) {
        TextItemUtil.encode(buffer, this.item);
    }

    public static ClientBoundMessagePacket decode(FriendlyByteBuf buffer) {
        TextItem component = TextItemUtil.decode(buffer);
        return new ClientBoundMessagePacket(component);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                TextComponent component = ComponentUtil.buildComponentFromTextItem(this.item);
                player.m_6352_((Component)component, player.m_142081_());
            }
        });
    }
}

