/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.ClientPrompt;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.prompt.OptionPromptItemData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundMultiSelectOptionPromptOpenPacket {
    private final UUID uuid;
    private final String title;
    private final String text;
    private final List<OptionPromptItemData> options;

    public ClientBoundMultiSelectOptionPromptOpenPacket(UUID uuid, String title, String text, List<OptionPromptItemData> options) {
        this.uuid = uuid;
        this.title = title;
        this.text = text;
        this.options = options;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.title);
        buffer.m_130070_(this.text);
        buffer.writeInt(this.options.size());
        for (OptionPromptItemData option : this.options) {
            buffer.writeInt(option.id());
            buffer.m_130070_(option.label());
            if (option.description() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(option.description());
                continue;
            }
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundMultiSelectOptionPromptOpenPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        String title = buffer.m_130277_();
        String text = buffer.m_130277_();
        int listSize = buffer.readInt();
        ArrayList<OptionPromptItemData> options = new ArrayList<OptionPromptItemData>(listSize);
        for (int i = 0; i < listSize; ++i) {
            int id = buffer.readInt();
            String label = buffer.m_130277_();
            String description = buffer.readBoolean() ? buffer.m_130277_() : null;
            OptionPromptItemData option = new OptionPromptItemData(id, label, description);
            options.add(option);
        }
        return new ClientBoundMultiSelectOptionPromptOpenPacket(uuid, title, text, options);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ClientPrompt.showMultiSelectOptionPrompt(this.uuid, this.title, this.text, this.options));
    }
}

