/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.gui.NPCActionMenuScreen;
import com.equestricraft.mod.npc.NpcActionInfo;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundNPCActionMenuOpenPacket {
    private final String title;
    private final List<NpcActionInfo> actions;

    public ClientBoundNPCActionMenuOpenPacket(String title, List<NpcActionInfo> actions) {
        this.title = title;
        this.actions = actions;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.title);
        buffer.writeInt(this.actions.size());
        for (NpcActionInfo action : this.actions) {
            buffer.m_130070_(action.label());
            buffer.m_130077_(action.identifier());
        }
    }

    public static ClientBoundNPCActionMenuOpenPacket decode(FriendlyByteBuf buffer) {
        String title = buffer.m_130277_();
        int amount = buffer.readInt();
        ArrayList<NpcActionInfo> actions = new ArrayList<NpcActionInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            String label = buffer.m_130277_();
            UUID identifier = buffer.m_130259_();
            actions.add(new NpcActionInfo(label, identifier));
        }
        return new ClientBoundNPCActionMenuOpenPacket(title, actions);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> NPCActionMenuScreen.showScreen(this.title, this.actions));
    }
}

