/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.mod.client.gui.plot.PlotNaturalPurchaseScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundNaturalPlotPurchaseMenuOpenPacket {
    private final DirectionalCoordinate coordinate;
    private final int settingsMinimumPlotRadius;

    public ClientBoundNaturalPlotPurchaseMenuOpenPacket(DirectionalCoordinate coordinate, int settingsMinimumPlotRadius) {
        this.coordinate = coordinate;
        this.settingsMinimumPlotRadius = settingsMinimumPlotRadius;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.coordinate.x());
        buffer.writeDouble(this.coordinate.y());
        buffer.writeDouble(this.coordinate.z());
        buffer.m_130070_(this.coordinate.world());
        buffer.writeFloat(this.coordinate.rotationY());
        buffer.writeFloat(this.coordinate.rotationX());
        buffer.writeInt(this.settingsMinimumPlotRadius);
    }

    public static ClientBoundNaturalPlotPurchaseMenuOpenPacket decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        String world = buffer.m_130277_();
        float rotationY = buffer.readFloat();
        float rotationZ = buffer.readFloat();
        DirectionalCoordinate coordinate = new DirectionalCoordinate(x, y, z, world, rotationY, rotationZ);
        int settingsMinimumPlotRadius = buffer.readInt();
        return new ClientBoundNaturalPlotPurchaseMenuOpenPacket(coordinate, settingsMinimumPlotRadius);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlotNaturalPurchaseScreen.showScreen(this.coordinate, this.settingsMinimumPlotRadius));
    }
}

